#version 330

layout(location = 0) in vec3 aPosition;
layout(location = 1) in vec3 aNormal;
layout(location = 2) in vec4 aColor;

out vec3 vNormal;
out vec4 vColor;

uniform mat4 uModelToWorld;
uniform mat4 uWorldToClip;
uniform mat4 uOriginToClip;

uniform bool uUseModel;
uniform bool uUseOrigin;

void main()
{
    mat4 T;
    if (uUseOrigin)
    {
        T = uOriginToClip;
    }
    else if (uUseModel)
    {
        T = uWorldToClip * uModelToWorld;
    }
    else
    {
        T = uWorldToClip;
    }


    gl_Position = T * vec4(aPosition, 1.0f);
    vNormal = aNormal;
    vColor = aColor;
}
